/************************************************************************************
* This file contains the functions related to the Freescale LabVIEW Sensor GUI,
* as well as explanations on the frame format.
*
*
* (c) Copyright 2012, Freescale Semiconductor, Inc. All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
************************************************************************************/

/*********************************************
* Includes
*********************************************/
#include "FunctionLib.h"
#include "UART_Interface.h"
#include "main.h"
#include "Utilities_Interface.h"


/*********************************************
* SendDataToLabviewSensorGUI                 *
* See description and information            *
* in the header file                         *
*********************************************/

void SendDataToLabviewSensorGUI(unsigned char* tmpbuf, uint8_t gau8RxDataBuffer[], uint16_t counter, uint8_t Frame_Verification_Result)
{
   unsigned char hex_word[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
  
   tmpbuf[0] = '[';
   tmpbuf[1] = 'D';
   tmpbuf[2] = 'A';
   tmpbuf[3] = '0';
   tmpbuf[4] = '8';
   tmpbuf[5] = '0';
   tmpbuf[6] = '0';
   tmpbuf[7] = '0';
   tmpbuf[8] = '1';
   tmpbuf[9] = '1';
   tmpbuf[10] = '2';
   tmpbuf[11] = '3';
   tmpbuf[12] = '4';
   tmpbuf[13] = hex_word[(gau8RxDataBuffer[8] >> 4)&0x0f]; // Pressure
   tmpbuf[14] = hex_word[(gau8RxDataBuffer[8] & 0x0f)];
   tmpbuf[15] = hex_word[(gau8RxDataBuffer[9] >> 4)&0x0f]; // Pressure
   tmpbuf[16] = hex_word[(gau8RxDataBuffer[9] & 0x0f)];
   tmpbuf[17] = hex_word[(gau8RxDataBuffer[10] >> 4)&0x0f]; // Z accel
   tmpbuf[18] = hex_word[(gau8RxDataBuffer[10] & 0x0f)];
   tmpbuf[19] = hex_word[(gau8RxDataBuffer[11] >> 4)&0x0f]; // Z accel
   tmpbuf[20] = hex_word[(gau8RxDataBuffer[11] & 0x0f)];
   tmpbuf[21] = hex_word[(gau8RxDataBuffer[12] >> 4)&0x0f]; // X accel
   tmpbuf[22] = hex_word[(gau8RxDataBuffer[12] & 0x0f)];
   tmpbuf[23] = hex_word[(gau8RxDataBuffer[13] >> 4)&0x0f]; // X accel
   tmpbuf[24] = hex_word[(gau8RxDataBuffer[13] & 0x0f)];
   tmpbuf[25] = hex_word[(gau8RxDataBuffer[14] >> 4)&0x0f]; // Volt
   tmpbuf[26] = hex_word[(gau8RxDataBuffer[14] & 0x0f)];  
   tmpbuf[27] = hex_word[(gau8RxDataBuffer[15] >> 4)&0x0f]; // Temp
   tmpbuf[28] = hex_word[(gau8RxDataBuffer[15] & 0x0f)];
   tmpbuf[29] = hex_word[(gau8RxDataBuffer[16] >> 4)&0x0f]; // Status Acq
   tmpbuf[30] = hex_word[(gau8RxDataBuffer[16] & 0x0f)];
   tmpbuf[31] = hex_word[(Frame_Verification_Result >> 4)&0x0f]; // Frame Verification Result (refer to header file)
   tmpbuf[32] = hex_word[(Frame_Verification_Result)&0x0f];
   tmpbuf[33] = hex_word[(counter >> 12)&0x0f]; // Cnt
   tmpbuf[34] = hex_word[(counter >> 8)&0x0f];
   tmpbuf[35] = hex_word[(counter >> 4)&0x0f]; 
   tmpbuf[36] = hex_word[(counter)&0x0f];
   tmpbuf[37] = ']';
   
   (void)UartX_Transmit(&tmpbuf[0], 38, UartTxCallBack);
   while (UartX_IsTxActive());
}


/*********************************************
* DisplayMessage                             *
*********************************************/
void DisplayMessage(uint8_t *ptr_data,uint8_t len)         
{
/*
MESSAGE FRAME

	 [ 		START
	 Type 	2 characters : Identify type of data being sent
				     MS 	Follow up message displayed in GUI
	 		    	 MP  	Pop up message displayed as a pop up with user to be required to press OK
 	 NB  	4 characters: Number of characters sent
 	C1 characters 1,
 	C2 characters 2,
 	C3 characters 3,
 	C4 characters 4,
 	C5 characters 5,
 	C6 characters 6,
 	
 	 ]  		END
*/


 uint8_t length;
 uint8_t *ptr_data_RF;
 uint8_t DataTxMSG[128]; 
 unsigned char hex_word[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
 
 length=(len+8);
 
 DataTxMSG[0]='[';   //ASCII: 0x5B
 DataTxMSG[1]='M';   //ASCII: 0x4D 
 DataTxMSG[2]='S';   //ASCII: 0x53 
 DataTxMSG[3]='0'; 
 DataTxMSG[4]='0';
 DataTxMSG[5]=hex_word[(len>>4) & 0x0f];
 DataTxMSG[6]=hex_word[len&0x0F]; 
 DataTxMSG[(len+7)]=']';  //ASCII: 0x5D 
  
 ptr_data_RF = &DataTxMSG[7];
 
 while(len--) 
 {
  *(ptr_data_RF++) = *(ptr_data++);
 }
 (void)UartX_Transmit(&DataTxMSG[0], length, UartTxCallBack);
  
  Delay_ms(500);

}


/*********************************************
* DisplayPopUp                               *
*********************************************/
void DisplayPopUp(uint8_t *ptr_data,uint8_t len)         
{
/*
MESSAGE FRAME

	 [ 		START
	 Type 	2 characters : Identify type of data being sent
				     MS 	Follow up message displayed in GUI
	 		    	 MP  	Pop up message displayed as a pop up with user to be required to press OK
 	 NB  	4 characters: Number of characters sent
 	C1 characters 1,
 	C2 characters 2,
 	C3 characters 3,
 	C4 characters 4,
 	C5 characters 5,
 	C6 characters 6,
 	
 	 ]  		END
*/


 uint8_t length;
 uint8_t *ptr_data_RF;
 uint8_t DataTxMSG[128]; 
 unsigned char hex_word[16] = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
 
 length=(len+8);
 
 DataTxMSG[0]='[';   //ASCII: 0x5B
 DataTxMSG[1]='M';   //ASCII: 0x4D 
 DataTxMSG[2]='P';   //ASCII: 0x53 
 DataTxMSG[3]='0'; 
 DataTxMSG[4]='0';
 DataTxMSG[5]=hex_word[(len>>4) & 0x0f];
 DataTxMSG[6]=hex_word[len&0x0F];   
 DataTxMSG[(len+7)]=']';  //ASCII: 0x5D 
  
 ptr_data_RF = &DataTxMSG[7];
 
 while(len--) 
 {
  *(ptr_data_RF++) = *(ptr_data++);
 }
 
 (void)UartX_Transmit(&DataTxMSG[0], length, UartTxCallBack);
 
  Delay_ms(500);

}

